function v=findnodes(vertices,elements,xfoot,yfoot,bxmin,bymin,bxmax,bymax)
%FINDNODES
%   V=FINDNODES(P,T,XF,YF,BXMIN,BYMIN,BXMAX,BYMAX) tries to find the
%   elements of the pdetool mesh (P,T) which contain the nodes (XF,YF), 
%   where XF and YF are two column vectors. BXMIN,BXMAX,BYMIN,BYMAX are
%   the estrema of the bounding-boxes of the triangles of the mesh.
%
%   See also COMPUTEBBOX.

% F.Saleri, 21.11.02
% G.Scrofani 14/01/2005

toll=1e-2;

lx = length(xfoot);
if lx ~= length(yfoot)
    error(' Vector dimensions must agree');
end
v = ones(lx,4)*NaN;
for i = 1:lx
    ssd=inf;
    iex = find((xfoot(i)-bxmin>=-toll)&(xfoot(i)-bxmax<=toll));
    if (~isempty(iex))
        iey = iex(find((yfoot(i)-bymin(iex)>=-toll)&(yfoot(i)-bymax(iex)<=toll)));
        if (~isempty(iey))
            le = length(iey);
            rhs = [xfoot(i); yfoot(i); 1];
            m = 1;
            v(i,1:4) = NaN;
            while (m <= le)
                ee = elements(1:3,iey(m));
                xt = vertices(1,ee'); yt = vertices(2,ee');
                A = [xt; yt; [1 1 1 ]]; 
                s = A\rhs;
                ss = sum((s <= 1+1.e-10)&(s>=-1.e-10)); 
                ssdold=ssd;
                ssd=sum(abs(s));
                if (ss == 3)
                    v(i,1) = iey(m);
                    v(i,2) = s(1);
                    v(i,3) = s(2);
                    v(i,4) = s(3);
                    m = le;
                elseif (abs(ssd)<abs(ssdold))
                    v(i,1) = iey(m);
                    v(i,2) = s(1);
                    v(i,3) = s(2);
                    v(i,4) = s(3);
                end
               m = m+1;
           end
       end
   end   
   if isnan(v(i,1))
       warning('The node (%f,%f) is not in the given triangulation \n ',xfoot(i),yfoot(i));
       v(i,2) = xfoot(i);
       v(i,3) = yfoot(i);

  %elseif (ss~=3)
       %ssd,beep
       %fprintf('Approximation occurred for node (%f,%f)\n ',xfoot(i),yfoot(i));
   end
   
end

return
